﻿#region: CMTraceLog Function formats logging in CMTrace style
        function CMTraceLog {
         [CmdletBinding()]
    Param (
		    [Parameter(Mandatory=$false)]
		    $Message,
		    [Parameter(Mandatory=$false)]
		    $ErrorMessage, 
		    [Parameter(Mandatory=$false)]
		    $Component, 
		    [Parameter(Mandatory=$false)]
		    [int]$Type,		
		    [Parameter(Mandatory=$true)]
		    $LogFile
	    )
    <#
    Type: 1 = Normal, 2 = Warning (yellow), 3 = Error (red)
    #>
	    $Time = Get-Date -Format "HH:mm:ss.ffffff"
	    $Date = Get-Date -Format "MM-dd-yyyy"
	    if ($ErrorMessage -ne $null) {$Type = 3}
	    if ($Component -eq $null) {$Component = " "}
	    if ($Type -eq $null) {$Type = 1}
	    $LogMessage = "<![LOG[$Message $ErrorMessage" + "]LOG]!><time=`"$Time`" date=`"$Date`" component=`"$Component`" context=`"`" type=`"$Type`" thread=`"`" file=`"`">"
	    $LogMessage.Replace("`0","") | Out-File -Append -Encoding UTF8 -FilePath $LogFile
    }


$tsenv = New-Object -ComObject Microsoft.SMS.TSEnvironment
$LogPath = $tsenv.Value('_SMSTSLogPath')
$LogFile = "$LogPath\WaaS_LangPack.log"


$Mode = $tsenv.Value('SMSTS_TSWaaSMode') #This Var is set at the start of each TS
if ($Mode -ne $null)
    {
    if ($Mode -eq "Upgrade")
    {
    $CurrentOSInfo = Get-Item -Path 'HKLM:\SOFTWARE\Microsoft\Windows NT\CurrentVersion'
    $ReleaseID_CurrentOS = $CurrentOSInfo.GetValue('ReleaseId')
    if ($ReleaseID_CurrentOS -eq $tsenv.Value('SMSTS_Build'))
        {
        $ComponetSuffix = "PostSetup"
        }
    Else
        {
        $ComponetSuffix = "PreSetup"
        }    
    $Component = "$($mode):LP:$($ComponetSuffix)"
    }
    Else
        {$Component = "$($mode):LP"}
    }
else {$Component = "LangPack"}

Write-Output "-------------------------------------------"
Write-Output "Starting Language Pack Script"
CMTraceLog -Message "" -Type 1 -LogFile $LogFile
CMTraceLog -Message " Starting Language Pack Script" -Type 1 -LogFile $LogFile -Component $Component

#Setting the Language Pack Path Variable
$TSCACHE = "_SMSTSPackageCacheLocation" + $tsenv.Value('W10X64LANGPACKAGE')
$CCMCACHE = "_SMSTS" + $tsenv.Value('W10X64LANGPACKAGE')
if ($tsenv.Value($TSCACHE)) {$tsenv.Value('LANG01') = $tsenv.Value($TSCACHE)}
if ($tsenv.Value($CCMCACHE)) {$tsenv.Value('LANG01') = $tsenv.Value($CCMCACHE)}
write-output "LANG01:$($tsenv.Value('LANG01'))"


#Additional Logging
CMTraceLog -Message "  Detected Language = $($tsenv.Value('SMSTS_WinSystemLocale')) " -Type 1 -LogFile $LogFile -Component $Component
Write-Output "  Detected Language = $($tsenv.Value('SMSTS_WinSystemLocale')) "

CMTraceLog -Message "  LANG01:$($tsenv.Value('LANG01'))" -Type 1 -LogFile $LogFile -Component $Component
Write-Output "  LANG01:$($tsenv.Value('LANG01'))"

if ($tsenv.Value('LangPackageName') -ne "" -or $tsenv.Value('LangPackageName') -ne $null)
    {
    $LangPackageName = $tsenv.Value('LangPackageName')
    CMTraceLog -Message  "Package Name: $LangPackageName " -Type 1 -LogFile $LogFile -Component $Component
    Write-Output "  Package Name: $LangPackageName "
    }

CMTraceLog -Message "Package ID: $($tsenv.Value('W10X64LANGPACKAGE')) " -Type 1 -LogFile $LogFile -Component $Component
Write-Output "  Package ID: $($tsenv.Value('W10X64LANGPACKAGE')) "

CMTraceLog -Message "GEOID: $($tsenv.Value('GEOID')) " -Type 1 -LogFile $LogFile -Component $Component
Write-Output "  GEOID: $($tsenv.Value('GEOID')) "

CMTraceLog -Message  "KeyboardLocale: $($tsenv.Value('KeyboardLocale')) " -Type 1 -LogFile $LogFile -Component $Component
Write-Output "  KeyboardLocale: $($tsenv.Value('KeyboardLocale')) "

CMTraceLog -Message  "Finished Language Pack Script" -Type 1 -LogFile $LogFile -Component $Component
Write-Output "Finished Language Pack Script"

CMTraceLog -Message "" -Type 1 -LogFile $LogFile
